<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\Vessel;
use App\Models\VesselCertificate;

class CheckVesselCertificates extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'vessels:check-certificates';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Check vessels for certificates and display counts';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $this->info('Checking vessels for certificates...');

        $vessels = Vessel::all();
        $this->info("Found {$vessels->count()} vessels");

        $table = [];
        $vesselsWithZeroCertificates = 0;

        foreach ($vessels as $vessel) {
            $certificateCount = VesselCertificate::where('vessel_id', $vessel->id)->count();
            
            $table[] = [
                'id' => $vessel->id,
                'name' => $vessel->name,
                'certificates' => $certificateCount,
            ];

            if ($certificateCount === 0) {
                $vesselsWithZeroCertificates++;
            }
        }

        $this->table(['ID', 'Vessel Name', 'Certificate Count'], $table);
        $this->info("Vessels with 0 certificates: {$vesselsWithZeroCertificates}");

        return 0;
    }
}
