<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class VesselPlan extends Model
{
    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'vessel_id',
        'plan_id',
        'attachment_path',
    ];

    /**
     * Get the vessel that owns the plan.
     */
    public function vessel()
    {
        return $this->belongsTo(Vessel::class);
    }

    /**
     * Get the plan that this vessel plan belongs to.
     */
    public function plan()
    {
        return $this->belongsTo(Plan::class);
    }
}
