<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class VesselSurvey extends Model
{
    protected $fillable = [
        'vessel_id',
        'survey_id',
        'last_date',
        'due_date',
        'window_date',
        'status',
        'general_note',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array
     */
    protected $casts = [
        'last_date' => 'datetime',
        'due_date' => 'datetime',
        'window_date' => 'datetime',
    ];

    /**
     * Get the survey that belongs to this vessel survey.
     */
    public function survey()
    {
        return $this->belongsTo(Survey::class);
    }
}
