<?php

require __DIR__.'/vendor/autoload.php';

$app = require_once __DIR__.'/bootstrap/app.php';

$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

use App\Models\User;
use Illuminate\Support\Facades\Hash;

// Check if admin user already exists
$admin = User::where('username', 'admin')->first();

if ($admin) {
    echo "Admin user already exists.\n";
} else {
    // Create admin user
    $admin = User::create([
        'username' => 'admin',
        'password' => Hash::make('password'),
        'is_admin' => true,
        'permissions' => [
            'vessels' => true,
            'certificates' => true,
            'warnings' => true,
            'manage_certificates' => true,
            'particulars' => true,
            'surveys' => true,
            'manage_surveys' => true,
            'plans' => true,
            'manage_plans' => true
        ]
    ]);

    echo "Admin user created successfully.\n";
    echo "Username: admin\n";
    echo "Password: password\n";
}

// Create a view-only user
$viewOnly = User::where('username', 'viewer')->first();

if ($viewOnly) {
    echo "View-only user already exists.\n";
} else {
    // Create view-only user
    $viewOnly = User::create([
        'username' => 'viewer',
        'password' => Hash::make('password'),
        'is_admin' => false,
        'permissions' => [
            'vessels' => true,
            'certificates' => false,
            'warnings' => true,
            'manage_certificates' => false,
            'particulars' => true,
            'surveys' => true,
            'manage_surveys' => false,
            'plans' => true,
            'manage_plans' => false
        ]
    ]);

    echo "View-only user created successfully.\n";
    echo "Username: viewer\n";
    echo "Password: password\n";
}
