@extends('layouts.app')

@section('content')
<div class="container-fluid">
    <div class="row mb-3">
        <div class="col-md-12">
            <h2>System Settings</h2>
        </div>
    </div>

    @if(session('success'))
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        {{ session('success') }}
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
    @endif

    @if(session('error'))
    <div class="alert alert-danger alert-dismissible fade show" role="alert">
        {{ session('error') }}
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
    @endif

    <ul class="nav nav-tabs mb-4" id="settingsTabs" role="tablist">
        <li class="nav-item" role="presentation">
            <button class="nav-link active" id="general-tab" data-bs-toggle="tab" data-bs-target="#general" type="button" role="tab" aria-controls="general" aria-selected="true">
                <i class="fas fa-cog"></i> General Settings
            </button>
        </li>
        <li class="nav-item" role="presentation">
            <button class="nav-link" id="certificates-tab" data-bs-toggle="tab" data-bs-target="#certificates" type="button" role="tab" aria-controls="certificates" aria-selected="false">
                <i class="fas fa-certificate"></i> Certificates
            </button>
        </li>
        <li class="nav-item" role="presentation">
            <button class="nav-link" id="system-tab" data-bs-toggle="tab" data-bs-target="#system" type="button" role="tab" aria-controls="system" aria-selected="false">
                <i class="fas fa-info-circle"></i> System Info
            </button>
        </li>
    </ul>

    <div class="tab-content" id="settingsTabsContent">
        <!-- General Settings Tab -->
        <div class="tab-pane fade show active" id="general" role="tabpanel" aria-labelledby="general-tab">
            <div class="card">
                <div class="card-header">
                    <h5>Warning Settings</h5>
                </div>
                <div class="card-body">
                    <form action="{{ route('settings.update-warning') }}" method="POST">
                        @csrf
                        @method('PUT')

                        <div class="row mb-3">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="warning_days" class="form-label">Certificate Warning Days</label>
                                    <input type="number" class="form-control @error('warning_days') is-invalid @enderror" id="warning_days" name="warning_days" value="{{ old('warning_days', $settings->warning_days ?? 30) }}" min="1" required>
                                    <div class="form-text">Number of days before expiry to show warning status</div>
                                    @error('warning_days')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="danger_days" class="form-label">Certificate Danger Days</label>
                                    <input type="number" class="form-control @error('danger_days') is-invalid @enderror" id="danger_days" name="danger_days" value="{{ old('danger_days', $settings->danger_days ?? 7) }}" min="1" required>
                                    <div class="form-text">Number of days before expiry to show danger status</div>
                                    @error('danger_days')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row mb-3">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="survey_warning_days" class="form-label">Survey Warning Days</label>
                                    <input type="number" class="form-control @error('survey_warning_days') is-invalid @enderror" id="survey_warning_days" name="survey_warning_days" value="{{ old('survey_warning_days', $settings->survey_warning_days ?? 90) }}" min="1" required>
                                    <div class="form-text">Number of days before due date to show warning status</div>
                                    @error('survey_warning_days')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="survey_danger_days" class="form-label">Survey Danger Days</label>
                                    <input type="number" class="form-control @error('survey_danger_days') is-invalid @enderror" id="survey_danger_days" name="survey_danger_days" value="{{ old('survey_danger_days', $settings->survey_danger_days ?? 30) }}" min="1" required>
                                    <div class="form-text">Number of days before due date to show danger status</div>
                                    @error('survey_danger_days')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="d-grid gap-2 d-md-flex justify-content-md-end">
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save"></i> Save Settings
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <!-- Certificates Tab -->
        <div class="tab-pane fade" id="certificates" role="tabpanel" aria-labelledby="certificates-tab">
            <div class="row">
                <div class="col-md-12 mb-4">
                    <div class="card">
                        <div class="card-header d-flex justify-content-between align-items-center">
                            <h5 class="mb-0">Create New Certificate</h5>
                        </div>
                        <div class="card-body">
                            <form action="{{ route('settings.create-certificate') }}" method="POST" class="row g-3">
                                @csrf
                                <div class="col-md-5">
                                    <label for="name" class="form-label">Certificate Name</label>
                                    <input type="text" class="form-control @error('name') is-invalid @enderror" id="name" name="name" required>
                                    @error('name')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="col-md-5">
                                    <label for="category" class="form-label">Category</label>
                                    <input type="text" class="form-control @error('category') is-invalid @enderror" id="category" name="category" required list="categories">
                                    <datalist id="categories">
                                        @foreach($categories as $category)
                                            <option value="{{ $category }}">
                                        @endforeach
                                    </datalist>
                                    @error('category')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="col-md-2 d-flex align-items-end">
                                    <button type="submit" class="btn btn-primary">
                                        <i class="fas fa-plus-circle"></i> Create
                                    </button>
                                </div>
                                <div class="col-md-12">
                                    <small class="text-muted">New certificates are automatically added to all vessels.</small>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>



            <div class="row">
                <div class="col-md-12">
                    <div class="card">
                        <div class="card-header d-flex justify-content-between align-items-center">
                            <h5 class="mb-0">Certificate Reordering</h5>
                            <div>
                                <button id="saveOrderBtn" class="btn btn-success btn-sm" style="display: none;">
                                    <i class="fas fa-save"></i> Save Order
                                </button>
                            </div>
                        </div>
                        <div class="card-body">
                            <div class="alert alert-info">
                                <i class="fas fa-info-circle"></i> Drag and drop certificates to reorder them. Changes will be applied to all vessels.
                            </div>

                            <div class="table-responsive">
                                <table class="table table-striped table-hover">
                                    <thead>
                                        <tr>
                                            <th width="5%">#</th>
                                            <th width="30%">Category</th>
                                            <th width="50%">Certificate Name</th>
                                            <th width="15%">Display Order</th>
                                        </tr>
                                    </thead>
                                    <tbody id="certificatesTableBody">
                                        @foreach($certificates->groupBy('category') as $category => $categoryCertificates)
                                            @foreach($categoryCertificates->sortBy('display_order') as $certificate)
                                                <tr class="certificate-row" data-id="{{ $certificate->id }}" data-order="{{ $certificate->display_order }}">
                                                    <td>{{ $loop->parent->index + 1 }}.{{ $loop->index + 1 }}</td>
                                                    <td>{{ $category }}</td>
                                                    <td>{{ $certificate->name }}</td>
                                                    <td>
                                                        <span class="order-display">{{ $certificate->display_order }}</span>
                                                        <input type="hidden" class="order-input" value="{{ $certificate->display_order }}">
                                                    </td>
                                                </tr>
                                            @endforeach
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- System Info Tab -->
        <div class="tab-pane fade" id="system" role="tabpanel" aria-labelledby="system-tab">
            <div class="card">
                <div class="card-header">
                    <h5>System Information</h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <p><strong>Laravel Version:</strong> {{ app()->version() }}</p>
                            <p><strong>PHP Version:</strong> {{ phpversion() }}</p>
                            <p><strong>Database:</strong> {{ config('database.default') }}</p>
                        </div>
                        <div class="col-md-6">
                            <p><strong>Total Vessels:</strong> {{ \App\Models\Vessel::count() }}</p>
                            <p><strong>Total Certificates:</strong> {{ \App\Models\Certificate::count() }}</p>
                            <p><strong>Total Surveys:</strong> {{ \App\Models\Survey::count() }}</p>
                            <p><strong>Total Users:</strong> {{ \App\Models\User::count() }}</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script src="https://cdn.jsdelivr.net/npm/sortablejs@1.14.0/Sortable.min.js"></script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Initialize Sortable for the certificates table
    const certificatesTableBody = document.getElementById('certificatesTableBody');
    const saveOrderBtn = document.getElementById('saveOrderBtn');

    if (certificatesTableBody) {
        let sortable = new Sortable(certificatesTableBody, {
            animation: 150,
            handle: '.certificate-row',
            ghostClass: 'bg-light',
            onEnd: function() {
                // Update order numbers
                updateOrderNumbers();
                // Show save button
                saveOrderBtn.style.display = 'inline-block';
            }
        });

        // Function to update order numbers
        function updateOrderNumbers() {
            const rows = certificatesTableBody.querySelectorAll('.certificate-row');
            rows.forEach((row, index) => {
                const orderDisplay = row.querySelector('.order-display');
                const orderInput = row.querySelector('.order-input');

                orderDisplay.textContent = index + 1;
                orderInput.value = index + 1;
            });
        }

        // Save order button click handler
        if (saveOrderBtn) {
            saveOrderBtn.addEventListener('click', function() {
                const rows = certificatesTableBody.querySelectorAll('.certificate-row');
                const certificates = [];

                rows.forEach(row => {
                    certificates.push({
                        id: row.dataset.id,
                        display_order: row.querySelector('.order-input').value
                    });
                });

                // Send AJAX request to save order
                fetch('{{ route("settings.reorder-certificates") }}', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': '{{ csrf_token() }}'
                    },
                    body: JSON.stringify({ certificates: certificates })
                })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        // Show success message
                        alert('Certificate order saved successfully!');
                        // Hide save button
                        saveOrderBtn.style.display = 'none';
                    } else {
                        alert('Error: ' + data.message);
                    }
                })
                .catch(error => {
                    console.error('Error:', error);
                    alert('An error occurred while saving the certificate order.');
                });
            });
        }
    }

    // Activate tab based on hash in URL
    const hash = window.location.hash;
    if (hash) {
        const tab = document.querySelector(`#settingsTabs button[data-bs-target="${hash}"]`);
        if (tab) {
            const bsTab = new bootstrap.Tab(tab);
            bsTab.show();
        }
    }
});
</script>
@endsection
