@extends('layouts.app')

@section('content')
<div class="container-fluid">
    <div class="row mb-3">
        <div class="col-md-6">
            <h2>Edit User: {{ $user->username }}</h2>
        </div>
        <div class="col-md-6 text-end">
            <a href="{{ route('users.index') }}" class="btn btn-secondary">
                <i class="fas fa-arrow-left"></i> Back to Users
            </a>
        </div>
    </div>

    <div class="card">
        <div class="card-header">
            <h5>User Details</h5>
        </div>
        <div class="card-body">
            <form action="{{ route('users.update', $user) }}" method="POST">
                @csrf
                @method('PUT')
                
                <div class="mb-3">
                    <label for="username" class="form-label">Username</label>
                    <input type="text" class="form-control @error('username') is-invalid @enderror" id="username" name="username" value="{{ old('username', $user->username) }}" required>
                    @error('username')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
                
                <div class="mb-3">
                    <label for="password" class="form-label">Password</label>
                    <input type="password" class="form-control @error('password') is-invalid @enderror" id="password" name="password" placeholder="Leave blank to keep current password">
                    <div class="form-text">Leave blank to keep the current password.</div>
                    @error('password')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
                
                <div class="mb-3">
                    <label for="password_confirmation" class="form-label">Confirm Password</label>
                    <input type="password" class="form-control" id="password_confirmation" name="password_confirmation" placeholder="Leave blank to keep current password">
                </div>
                
                <div class="mb-3">
                    <label class="form-label">User Type</label>
                    <div class="form-check">
                        <input class="form-check-input" type="radio" name="user_type" id="user_type_admin" value="admin" {{ $user->is_admin ? 'checked' : '' }}>
                        <label class="form-check-label" for="user_type_admin">
                            Admin (Full Access)
                        </label>
                    </div>
                    <div class="form-check">
                        <input class="form-check-input" type="radio" name="user_type" id="user_type_view_only" value="view_only" {{ (!$user->is_admin && $user->isViewOnly()) ? 'checked' : '' }}>
                        <label class="form-check-label" for="user_type_view_only">
                            View Only (No Edit Permissions)
                        </label>
                    </div>
                    <div class="form-check">
                        <input class="form-check-input" type="radio" name="user_type" id="user_type_custom" value="custom" {{ (!$user->is_admin && !$user->isViewOnly()) ? 'checked' : '' }}>
                        <label class="form-check-label" for="user_type_custom">
                            Custom Permissions
                        </label>
                    </div>
                </div>
                
                <div id="custom_permissions" class="mb-3 border p-3 rounded" style="{{ (!$user->is_admin && !$user->isViewOnly()) ? '' : 'display: none;' }}">
                    <h6>Custom Permissions</h6>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-check mb-2">
                                <input class="form-check-input" type="checkbox" name="permission_vessels" id="permission_vessels" checked disabled>
                                <label class="form-check-label" for="permission_vessels">
                                    View Vessels (Always Enabled)
                                </label>
                            </div>
                            
                            <div class="form-check mb-2">
                                <input class="form-check-input" type="checkbox" name="permission_certificates" id="permission_certificates" {{ $user->hasPermission('certificates') ? 'checked' : '' }}>
                                <label class="form-check-label" for="permission_certificates">
                                    View Certificates
                                </label>
                            </div>
                            
                            <div class="form-check mb-2">
                                <input class="form-check-input" type="checkbox" name="permission_manage_certificates" id="permission_manage_certificates" {{ $user->hasPermission('manage_certificates') ? 'checked' : '' }}>
                                <label class="form-check-label" for="permission_manage_certificates">
                                    Manage Certificates
                                </label>
                            </div>
                            
                            <div class="form-check mb-2">
                                <input class="form-check-input" type="checkbox" name="permission_warnings" id="permission_warnings" {{ $user->hasPermission('warnings') ? 'checked' : '' }}>
                                <label class="form-check-label" for="permission_warnings">
                                    View Warnings
                                </label>
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="form-check mb-2">
                                <input class="form-check-input" type="checkbox" name="permission_particulars" id="permission_particulars" {{ $user->hasPermission('particulars') ? 'checked' : '' }}>
                                <label class="form-check-label" for="permission_particulars">
                                    View Particulars
                                </label>
                            </div>
                            
                            <div class="form-check mb-2">
                                <input class="form-check-input" type="checkbox" name="permission_surveys" id="permission_surveys" {{ $user->hasPermission('surveys') ? 'checked' : '' }}>
                                <label class="form-check-label" for="permission_surveys">
                                    View Surveys
                                </label>
                            </div>
                            
                            <div class="form-check mb-2">
                                <input class="form-check-input" type="checkbox" name="permission_manage_surveys" id="permission_manage_surveys" {{ $user->hasPermission('manage_surveys') ? 'checked' : '' }}>
                                <label class="form-check-label" for="permission_manage_surveys">
                                    Manage Surveys
                                </label>
                            </div>
                            
                            <div class="form-check mb-2">
                                <input class="form-check-input" type="checkbox" name="permission_plans" id="permission_plans" {{ $user->hasPermission('plans') ? 'checked' : '' }}>
                                <label class="form-check-label" for="permission_plans">
                                    View Plans
                                </label>
                            </div>
                            
                            <div class="form-check mb-2">
                                <input class="form-check-input" type="checkbox" name="permission_manage_plans" id="permission_manage_plans" {{ $user->hasPermission('manage_plans') ? 'checked' : '' }}>
                                <label class="form-check-label" for="permission_manage_plans">
                                    Manage Plans
                                </label>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="d-grid gap-2 d-md-flex justify-content-md-end">
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-save"></i> Update User
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

@section('scripts')
<script>
    document.addEventListener('DOMContentLoaded', function() {
        const userTypeRadios = document.querySelectorAll('input[name="user_type"]');
        const customPermissionsDiv = document.getElementById('custom_permissions');
        
        userTypeRadios.forEach(radio => {
            radio.addEventListener('change', function() {
                if (this.value === 'custom') {
                    customPermissionsDiv.style.display = 'block';
                } else {
                    customPermissionsDiv.style.display = 'none';
                }
            });
        });
    });
</script>
@endsection
@endsection
