<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="row mb-3">
        <div class="col-md-6">
            <h2>Vessels</h2>
        </div>
        <div class="col-md-6 text-end">
            <?php if(auth()->user()->is_admin || auth()->user()->hasPermission('manage_certificates')): ?>
            <a href="<?php echo e(route('vessels.create')); ?>" class="btn btn-primary">
                <i class="fas fa-plus"></i> Add New Vessel
            </a>
            <?php endif; ?>
        </div>
    </div>

    <?php if(session('success')): ?>
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        <?php echo e(session('success')); ?>

        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
    <?php endif; ?>

    <?php if(session('error')): ?>
    <div class="alert alert-danger alert-dismissible fade show" role="alert">
        <?php echo e(session('error')); ?>

        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
    <?php endif; ?>

    <div class="card">
        <div class="card-header">
            <div class="row">
                <div class="col-md-6">
                    <h5>Vessel List</h5>
                </div>
                <div class="col-md-6">
                    <form action="<?php echo e(route('vessels.index')); ?>" method="GET" class="d-flex">
                        <input type="text" name="search" class="form-control me-2" placeholder="Search vessels..." value="<?php echo e(request('search')); ?>">
                        <button type="submit" class="btn btn-outline-light">Search</button>
                    </form>
                </div>
            </div>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-striped table-hover">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Name</th>
                            <th>Certificates</th>
                            <th>Warnings</th>
                            <th>Created</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $vessels; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $vessel): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td><?php echo e($vessel->id); ?></td>
                            <td><?php echo e($vessel->name); ?></td>
                            <td>
                                <?php
                                    $filledCertificates = $vessel->vesselCertificates->filter(function($cert) {
                                        return $cert->issued_date || $cert->expiry_date || $cert->attachment_path;
                                    })->count();
                                ?>
                                <?php echo e($filledCertificates); ?>

                            </td>
                            <td>
                                <?php
                                $warningSettings = \App\Models\WarningSettings::first();
                                $warningDays = $warningSettings ? $warningSettings->warning_days : 30;
                                $dangerDays = $warningSettings ? $warningSettings->danger_days : 7;

                                $expiring = 0;
                                $expired = 0;
                                $danger = 0;

                                foreach($vessel->vesselCertificates as $cert) {
                                    if($cert->expiry_date) {
                                        if($cert->expiry_date < now()) {
                                            $expired++;
                                        } elseif($cert->expiry_date < now()->addDays($dangerDays)) {
                                            $danger++;
                                        } elseif($cert->expiry_date < now()->addDays($warningDays)) {
                                            $expiring++;
                                        }
                                    }
                                }
                                ?>

                                <?php if($expired > 0): ?>
                                <span class="badge bg-dark text-white"><?php echo e($expired); ?> Expired</span>
                                <?php endif; ?>

                                <?php if($danger > 0): ?>
                                <span class="badge bg-danger"><?php echo e($danger); ?> Critical</span>
                                <?php endif; ?>

                                <?php if($expiring > 0): ?>
                                <span class="badge bg-warning text-dark"><?php echo e($expiring); ?> Warning</span>
                                <?php endif; ?>
                            </td>
                            <td><?php echo e($vessel->created_at->format('Y-m-d')); ?></td>
                            <td>
                                <div class="btn-group" role="group">
                                    <a href="<?php echo e(route('vessels.show', $vessel)); ?>" class="btn btn-sm btn-info">
                                        <i class="fas fa-eye"></i> View
                                    </a>

                                    <?php if(auth()->user()->is_admin || auth()->user()->hasPermission('manage_certificates')): ?>
                                    <a href="<?php echo e(route('vessels.edit', $vessel)); ?>" class="btn btn-sm btn-warning">
                                        <i class="fas fa-edit"></i> Edit
                                    </a>

                                    <button type="button" class="btn btn-sm btn-danger"
                                            onclick="if(confirm('Are you sure you want to delete this vessel? This will also delete all associated certificates.')) {
                                                document.getElementById('delete-vessel-<?php echo e($vessel->id); ?>').submit();
                                            }">
                                        <i class="fas fa-trash"></i> Delete
                                    </button>

                                    <form id="delete-vessel-<?php echo e($vessel->id); ?>" action="<?php echo e(route('vessels.destroy', $vessel)); ?>" method="POST" style="display: none;">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('DELETE'); ?>
                                    </form>
                                    <?php endif; ?>
                                </div>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="6" class="text-center">No vessels found.</td>
                        </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>


        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/ibrahimbchara/Downloads/certificates/vessel-certificates/resources/views/vessels/index.blade.php ENDPATH**/ ?>