<?php

namespace App\Http\Controllers;

use App\Models\Vessel;
use App\Models\VesselSurvey;
use App\Models\Survey;
use Illuminate\Http\Request;

class VesselSurveyController extends Controller
{
    /**
     * Store a newly created vessel survey in storage.
     */
    public function store(Request $request)
    {
        $request->validate([
            'vessel_id' => 'required|exists:vessels,id',
            'survey_id' => 'required|exists:surveys,id',
            'last_date' => 'nullable|date',
            'due_date' => 'nullable|date',
            'window_date' => 'nullable|date',
            'status' => 'nullable|string|max:100',
            'general_note' => 'nullable|string',
        ]);

        // Check if vessel already has this survey
        $existingSurvey = VesselSurvey::where('vessel_id', $request->vessel_id)
            ->where('survey_id', $request->survey_id)
            ->first();

        if ($existingSurvey) {
            return redirect()->back()
                ->with('error', 'This vessel already has this survey. Please edit the existing survey instead.');
        }

        $vesselSurvey = new VesselSurvey();
        $vesselSurvey->vessel_id = $request->vessel_id;
        $vesselSurvey->survey_id = $request->survey_id;
        $vesselSurvey->last_date = $request->last_date;
        $vesselSurvey->due_date = $request->due_date;
        $vesselSurvey->window_date = $request->window_date;
        $vesselSurvey->status = $request->status;
        $vesselSurvey->general_note = $request->general_note;
        $vesselSurvey->save();

        return redirect()->route('vessels.show', $request->vessel_id)
            ->with('success', 'Vessel survey added successfully.');
    }

    /**
     * Update the specified vessel survey in storage.
     */
    public function update(Request $request, VesselSurvey $vesselSurvey)
    {
        $request->validate([
            'survey_id' => 'required|exists:surveys,id',
            'last_date' => 'nullable|date',
            'due_date' => 'nullable|date',
            'window_date' => 'nullable|date',
            'status' => 'nullable|string|max:100',
            'general_note' => 'nullable|string',
        ]);

        $vesselSurvey->survey_id = $request->survey_id;
        $vesselSurvey->last_date = $request->last_date;
        $vesselSurvey->due_date = $request->due_date;
        $vesselSurvey->window_date = $request->window_date;
        $vesselSurvey->status = $request->status;
        $vesselSurvey->general_note = $request->general_note;
        $vesselSurvey->save();

        return redirect()->route('vessels.show', $vesselSurvey->vessel_id)
            ->with('success', 'Vessel survey updated successfully.');
    }

    /**
     * Remove the specified vessel survey from storage.
     */
    public function destroy(VesselSurvey $vesselSurvey)
    {
        $vesselId = $vesselSurvey->vessel_id;
        $vesselSurvey->delete();

        return redirect()->route('vessels.show', $vesselId)
            ->with('success', 'Vessel survey deleted successfully.');
    }
}
