<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Vessel extends Model
{
    use HasFactory;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'name',
    ];

    /**
     * Get the certificates for the vessel.
     */
    public function certificates()
    {
        return $this->belongsToMany(Certificate::class, 'vessel_certificates')
            ->withPivot('id', 'id_no', 'vessel_department', 'issued_date', 'expiry_date', 'attachment_path')
            ->withTimestamps();
    }

    /**
     * Get the vessel certificates.
     */
    public function vesselCertificates()
    {
        return $this->hasMany(VesselCertificate::class);
    }

    /**
     * Get the plans for the vessel.
     */
    public function plans()
    {
        return $this->belongsToMany(Plan::class, 'vessel_plans')
            ->withPivot('id', 'attachment_path');
    }

    /**
     * Get the vessel plans.
     */
    public function vesselPlans()
    {
        return $this->hasMany(VesselPlan::class);
    }

    /**
     * Get the surveys for the vessel.
     */
    public function surveys()
    {
        return $this->belongsToMany(Survey::class, 'vessel_surveys')
            ->withPivot('id', 'last_date', 'due_date', 'window_date', 'status', 'general_note');
    }

    /**
     * Get the vessel surveys.
     */
    public function vesselSurveys()
    {
        return $this->hasMany(VesselSurvey::class);
    }

    /**
     * Get the vessel particulars.
     */
    public function particulars()
    {
        return $this->hasOne(VesselParticular::class);
    }
}
