<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class VesselParticular extends Model
{
    use HasFactory;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'vessel_id',
        'imo_number',
        'attachment_path',
    ];

    /**
     * Get the vessel that owns the particulars.
     */
    public function vessel()
    {
        return $this->belongsTo(Vessel::class);
    }
}
