@extends('layouts.app')

@section('title', 'Survey Management')

@section('content')
<div class="container-fluid">
    <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
        <h1 class="h2">Survey Management</h1>
        <div class="btn-toolbar mb-2 mb-md-0">
            <div class="btn-group me-2">
                <a href="{{ route('settings.index') }}" class="btn btn-outline-secondary">
                    <i class="fas fa-arrow-left"></i> Back to Settings
                </a>
            </div>
        </div>
    </div>

    @if(session('success'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            {{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    @if(session('error'))
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            {{ session('error') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    <div class="card">
        <div class="card-header">
            <div class="row">
                <div class="col-md-6">
                    <h5><i class="fas fa-clipboard-list"></i> Surveys</h5>
                </div>
                <div class="col-md-6 text-end">
                    <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addSurveyModal">
                        <i class="fas fa-plus"></i> Add Survey
                    </button>
                </div>
            </div>
        </div>
        <div class="card-body">
            <!-- Filter -->
            <div class="row mb-3">
                <div class="col-md-4">
                    <label for="categoryFilter" class="form-label">Filter by Category:</label>
                    <select id="categoryFilter" class="form-select">
                        <option value="">All Categories</option>
                        @foreach($categories as $category)
                            <option value="{{ $category }}">{{ $category }}</option>
                        @endforeach
                    </select>
                </div>
            </div>

            <!-- Surveys Table -->
            <div class="table-responsive">
                <table class="table table-striped table-hover" id="surveysTable">
                    <thead>
                        <tr>
                            <th>Name</th>
                            <th>Category</th>
                            <th>Created</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($surveys as $survey)
                        <tr data-category="{{ $survey->category }}">
                            <td>{{ $survey->name }}</td>
                            <td>
                                <span class="badge bg-secondary">{{ $survey->category }}</span>
                            </td>
                            <td>{{ $survey->created_at->format('Y-m-d') }}</td>
                            <td>
                                <div class="btn-group" role="group">
                                    <button type="button" class="btn btn-sm btn-outline-primary" 
                                            onclick="editSurvey({{ $survey->id }}, '{{ $survey->name }}', '{{ $survey->category }}')">
                                        <i class="fas fa-edit"></i> Edit
                                    </button>
                                    <button type="button" class="btn btn-sm btn-outline-danger" 
                                            onclick="deleteSurvey({{ $survey->id }}, '{{ $survey->name }}')">
                                        <i class="fas fa-trash"></i> Delete
                                    </button>
                                </div>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>

            @if($surveys->isEmpty())
                <div class="text-center py-4">
                    <i class="fas fa-clipboard-list fa-3x text-muted mb-3"></i>
                    <h5 class="text-muted">No surveys found</h5>
                    <p class="text-muted">Click "Add Survey" to create your first survey.</p>
                </div>
            @endif
        </div>
    </div>
</div>

<!-- Add Survey Modal -->
<div class="modal fade" id="addSurveyModal" tabindex="-1" aria-labelledby="addSurveyModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <form action="{{ route('settings.create-survey') }}" method="POST">
                @csrf
                <div class="modal-header">
                    <h5 class="modal-title" id="addSurveyModalLabel">Add New Survey</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="surveyName" class="form-label">Survey Name</label>
                        <input type="text" class="form-control" id="surveyName" name="name" required>
                    </div>
                    <div class="mb-3">
                        <label for="surveyCategory" class="form-label">Category</label>
                        <input type="text" class="form-control" id="surveyCategory" name="category" required>
                        <div class="form-text">Examples: HULL, MACHINERY, SOLAS, etc.</div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary">Add Survey</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Edit Survey Modal -->
<div class="modal fade" id="editSurveyModal" tabindex="-1" aria-labelledby="editSurveyModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <form id="editSurveyForm" method="POST">
                @csrf
                @method('PUT')
                <div class="modal-header">
                    <h5 class="modal-title" id="editSurveyModalLabel">Edit Survey</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="editSurveyName" class="form-label">Survey Name</label>
                        <input type="text" class="form-control" id="editSurveyName" name="name" required>
                    </div>
                    <div class="mb-3">
                        <label for="editSurveyCategory" class="form-label">Category</label>
                        <input type="text" class="form-control" id="editSurveyCategory" name="category" required>
                        <div class="form-text">Examples: HULL, MACHINERY, SOLAS, etc.</div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary">Update Survey</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Delete Survey Modal -->
<div class="modal fade" id="deleteSurveyModal" tabindex="-1" aria-labelledby="deleteSurveyModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <form id="deleteSurveyForm" method="POST">
                @csrf
                @method('DELETE')
                <div class="modal-header">
                    <h5 class="modal-title" id="deleteSurveyModalLabel">Delete Survey</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <p>Are you sure you want to delete the survey "<strong id="deleteSurveyName"></strong>"?</p>
                    <div class="alert alert-warning">
                        <i class="fas fa-exclamation-triangle"></i>
                        <strong>Warning:</strong> This action cannot be undone. The survey will be permanently removed from the system.
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-danger">Delete Survey</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
// Category filter functionality
document.getElementById('categoryFilter').addEventListener('change', function() {
    const selectedCategory = this.value;
    const rows = document.querySelectorAll('#surveysTable tbody tr');
    
    rows.forEach(row => {
        const category = row.getAttribute('data-category');
        if (selectedCategory === '' || category === selectedCategory) {
            row.style.display = '';
        } else {
            row.style.display = 'none';
        }
    });
});

// Edit survey function
function editSurvey(id, name, category) {
    document.getElementById('editSurveyName').value = name;
    document.getElementById('editSurveyCategory').value = category;
    document.getElementById('editSurveyForm').action = `{{ url('/settings/surveys') }}/${id}`;

    new bootstrap.Modal(document.getElementById('editSurveyModal')).show();
}

// Delete survey function
function deleteSurvey(id, name) {
    document.getElementById('deleteSurveyName').textContent = name;
    document.getElementById('deleteSurveyForm').action = `{{ url('/settings/surveys') }}/${id}`;

    new bootstrap.Modal(document.getElementById('deleteSurveyModal')).show();
}
</script>
@endsection
