@extends('layouts.app')

@section('content')
<div class="container-fluid">
    <div class="row mb-3">
        <div class="col-md-6">
            <h2>Create New Vessel</h2>
        </div>
        <div class="col-md-6 text-end">
            <a href="{{ route('vessels.index') }}" class="btn btn-secondary">
                <i class="fas fa-arrow-left"></i> Back to Vessels
            </a>
        </div>
    </div>

    <div class="card">
        <div class="card-header">
            <h5>Vessel Details</h5>
        </div>
        <div class="card-body">
            <form action="{{ route('vessels.store') }}" method="POST">
                @csrf
                
                <div class="mb-3">
                    <label for="name" class="form-label">Vessel Name</label>
                    <input type="text" class="form-control @error('name') is-invalid @enderror" id="name" name="name" value="{{ old('name') }}" required>
                    @error('name')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
                
                <div class="d-grid gap-2 d-md-flex justify-content-md-end">
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-save"></i> Create Vessel
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection
