@extends('layouts.app')

@section('content')
<div class="container-fluid">
    <div class="row mb-3">
        <div class="col-md-6">
            <h2>Vessels</h2>
        </div>
        <div class="col-md-6 text-end">
            @if(auth()->user()->is_admin || auth()->user()->hasPermission('manage_certificates'))
            <a href="{{ route('vessels.create') }}" class="btn btn-primary">
                <i class="fas fa-plus"></i> Add New Vessel
            </a>
            @endif
        </div>
    </div>

    @if(session('success'))
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        {{ session('success') }}
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
    @endif

    @if(session('error'))
    <div class="alert alert-danger alert-dismissible fade show" role="alert">
        {{ session('error') }}
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
    @endif

    <div class="card">
        <div class="card-header">
            <div class="row">
                <div class="col-md-6">
                    <h5>Vessel List</h5>
                </div>
                <div class="col-md-6">
                    <form action="{{ route('vessels.index') }}" method="GET" class="d-flex">
                        <input type="text" name="search" class="form-control me-2" placeholder="Search vessels..." value="{{ request('search') }}">
                        <button type="submit" class="btn btn-outline-light">Search</button>
                    </form>
                </div>
            </div>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-striped table-hover">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Name</th>
                            <th>Certificates</th>
                            <th>Warnings</th>
                            <th>Created</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($vessels as $vessel)
                        <tr>
                            <td>{{ $vessel->id }}</td>
                            <td>{{ $vessel->name }}</td>
                            <td>
                                @php
                                    $filledCertificates = $vessel->vesselCertificates->filter(function($cert) {
                                        return $cert->issued_date || $cert->expiry_date || $cert->attachment_path;
                                    })->count();
                                @endphp
                                {{ $filledCertificates }}
                            </td>
                            <td>
                                @php
                                $warningSettings = \App\Models\WarningSettings::first();
                                $warningDays = $warningSettings ? $warningSettings->warning_days : 30;
                                $dangerDays = $warningSettings ? $warningSettings->danger_days : 7;

                                $expiring = 0;
                                $expired = 0;
                                $danger = 0;

                                foreach($vessel->vesselCertificates as $cert) {
                                    if($cert->expiry_date) {
                                        if($cert->expiry_date < now()) {
                                            $expired++;
                                        } elseif($cert->expiry_date < now()->addDays($dangerDays)) {
                                            $danger++;
                                        } elseif($cert->expiry_date < now()->addDays($warningDays)) {
                                            $expiring++;
                                        }
                                    }
                                }
                                @endphp

                                @if($expired > 0)
                                <span class="badge bg-dark text-white">{{ $expired }} Expired</span>
                                @endif

                                @if($danger > 0)
                                <span class="badge bg-danger">{{ $danger }} Critical</span>
                                @endif

                                @if($expiring > 0)
                                <span class="badge bg-warning text-dark">{{ $expiring }} Warning</span>
                                @endif
                            </td>
                            <td>{{ $vessel->created_at->format('Y-m-d') }}</td>
                            <td>
                                <div class="btn-group" role="group">
                                    <a href="{{ route('vessels.show', $vessel) }}" class="btn btn-sm btn-info">
                                        <i class="fas fa-eye"></i> View
                                    </a>

                                    @if(auth()->user()->is_admin || auth()->user()->hasPermission('manage_certificates'))
                                    <a href="{{ route('vessels.edit', $vessel) }}" class="btn btn-sm btn-warning">
                                        <i class="fas fa-edit"></i> Edit
                                    </a>

                                    <button type="button" class="btn btn-sm btn-danger"
                                            onclick="if(confirm('Are you sure you want to delete this vessel? This will also delete all associated certificates.')) {
                                                document.getElementById('delete-vessel-{{ $vessel->id }}').submit();
                                            }">
                                        <i class="fas fa-trash"></i> Delete
                                    </button>

                                    <form id="delete-vessel-{{ $vessel->id }}" action="{{ route('vessels.destroy', $vessel) }}" method="POST" style="display: none;">
                                        @csrf
                                        @method('DELETE')
                                    </form>
                                    @endif
                                </div>
                            </td>
                        </tr>
                        @empty
                        <tr>
                            <td colspan="6" class="text-center">No vessels found.</td>
                        </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>


        </div>
    </div>
</div>
@endsection
