<?php

// This script runs the fix_certificates.sql file to fix vessels with 0 certificates

// Load the Laravel environment
require __DIR__.'/vendor/autoload.php';
$app = require_once __DIR__.'/bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

// Get database configuration from Laravel
$config = config('database.connections.mysql');
$host = $config['host'];
$dbname = $config['database'];
$username = $config['username'];
$password = $config['password'];

try {
    // Connect to the database
    $pdo = new PDO("mysql:host=$host;dbname=$dbname", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    echo "Connected to database successfully\n";
    
    // Check current vessel certificates
    $stmt = $pdo->query("SELECT v.id, v.name, COUNT(vc.id) as certificate_count
                         FROM vessels v
                         LEFT JOIN vessel_certificates vc ON v.id = vc.vessel_id
                         GROUP BY v.id, v.name
                         ORDER BY certificate_count ASC");
    $vesselCertificateCounts = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo "Current vessel certificate counts:\n";
    foreach ($vesselCertificateCounts as $row) {
        echo "Vessel ID: " . $row['id'] . " - Name: " . $row['name'] . " - Certificates: " . $row['certificate_count'] . "\n";
    }
    
    // Read the SQL file
    $sqlFilePath = __DIR__ . '/fix_certificates.sql';
    if (!file_exists($sqlFilePath)) {
        echo "SQL file not found at: $sqlFilePath\n";
        exit(1);
    }
    
    $sqlContent = file_get_contents($sqlFilePath);
    
    // Split SQL file into individual statements
    $statements = explode(';', $sqlContent);
    
    // Begin transaction
    $pdo->beginTransaction();
    
    try {
        $executeCount = 0;
        
        foreach ($statements as $statement) {
            $statement = trim($statement);
            
            // Skip empty statements and comments
            if (empty($statement) || strpos($statement, '--') === 0) {
                continue;
            }
            
            // Skip SELECT statements
            if (stripos($statement, 'SELECT') === 0) {
                continue;
            }
            
            // Execute statement
            $pdo->exec($statement);
            $executeCount++;
            
            echo "Executed statement: " . substr($statement, 0, 50) . "...\n";
        }
        
        // Commit transaction
        $pdo->commit();
        
        echo "\nFix completed successfully!\n";
        echo "Executed $executeCount statements\n";
        
        // Check updated vessel certificates
        $stmt = $pdo->query("SELECT v.id, v.name, COUNT(vc.id) as certificate_count
                             FROM vessels v
                             LEFT JOIN vessel_certificates vc ON v.id = vc.vessel_id
                             GROUP BY v.id, v.name
                             ORDER BY certificate_count ASC");
        $updatedVesselCertificateCounts = $stmt->fetchAll(PDO::FETCH_ASSOC);
        
        echo "\nUpdated vessel certificate counts:\n";
        foreach ($updatedVesselCertificateCounts as $row) {
            echo "Vessel ID: " . $row['id'] . " - Name: " . $row['name'] . " - Certificates: " . $row['certificate_count'] . "\n";
        }
        
    } catch (Exception $e) {
        // Rollback transaction on error
        $pdo->rollBack();
        
        echo "Error during fix: " . $e->getMessage() . "\n";
        exit(1);
    }
    
} catch (PDOException $e) {
    echo "Database connection failed: " . $e->getMessage() . "\n";
    exit(1);
}
