<?php $__env->startSection('title', 'Database Management'); ?>

<?php $__env->startPush('head'); ?>
<meta http-equiv="Cache-Control" content="no-cache, no-store, must-revalidate">
<meta http-equiv="Pragma" content="no-cache">
<meta http-equiv="Expires" content="0">
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h1>Database Management</h1>
                <a href="<?php echo e(route('settings.index')); ?>" class="btn btn-secondary">
                    <i class="fas fa-arrow-left"></i> Back to Settings
                </a>
            </div>

            <?php if(session('success')): ?>
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    <?php echo e(session('success')); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            <?php endif; ?>

            <?php if(session('error')): ?>
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    <?php echo e(session('error')); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            <?php endif; ?>

            <!-- Duplicate Statistics -->
            <?php if($duplicateStats->count() > 0): ?>
                <div class="alert alert-warning">
                    <h5><i class="fas fa-exclamation-triangle"></i> Duplicate Certificates Found</h5>
                    <p>The following vessel-certificate combinations have duplicate records:</p>
                    <ul class="mb-0">
                        <?php $__currentLoopData = $duplicateStats; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $duplicate): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li>
                                <strong><?php echo e($duplicate->vessel->name); ?></strong> - 
                                <strong><?php echo e($duplicate->certificate->name); ?></strong> 
                                (<?php echo e($duplicate->count); ?> records)
                            </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                    <div class="mt-2">
                        <a href="<?php echo e(route('settings.database', ['show_duplicates' => 1])); ?>" class="btn btn-sm btn-warning">
                            <i class="fas fa-eye"></i> View Duplicates Only
                        </a>
                    </div>
                </div>
            <?php endif; ?>

            <!-- Filters -->
            <div class="card mb-4">
                <div class="card-header">
                    <h5><i class="fas fa-filter"></i> Filters</h5>
                </div>
                <div class="card-body">
                    <form method="GET" action="<?php echo e(route('settings.database')); ?>">
                        <div class="row">
                            <div class="col-md-3">
                                <label for="vessel_id" class="form-label">Vessel</label>
                                <select name="vessel_id" id="vessel_id" class="form-select">
                                    <option value="">All Vessels</option>
                                    <?php $__currentLoopData = $vessels; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $vessel): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($vessel->id); ?>" <?php echo e(request('vessel_id') == $vessel->id ? 'selected' : ''); ?>>
                                            <?php echo e($vessel->name); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <div class="col-md-3">
                                <label for="certificate_id" class="form-label">Certificate</label>
                                <select name="certificate_id" id="certificate_id" class="form-select">
                                    <option value="">All Certificates</option>
                                    <?php $__currentLoopData = $certificates; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $certificate): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($certificate->id); ?>" <?php echo e(request('certificate_id') == $certificate->id ? 'selected' : ''); ?>>
                                            <?php echo e($certificate->name); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <div class="col-md-2">
                                <label for="status" class="form-label">Status</label>
                                <select name="status" id="status" class="form-select">
                                    <option value="">All Status</option>
                                    <option value="expired" <?php echo e(request('status') == 'expired' ? 'selected' : ''); ?>>Expired</option>
                                    <option value="expiring_soon" <?php echo e(request('status') == 'expiring_soon' ? 'selected' : ''); ?>>Expiring Soon</option>
                                    <option value="valid" <?php echo e(request('status') == 'valid' ? 'selected' : ''); ?>>Valid</option>
                                    <option value="no_expiry" <?php echo e(request('status') == 'no_expiry' ? 'selected' : ''); ?>>No Expiry</option>
                                </select>
                            </div>
                            <div class="col-md-2">
                                <label for="search" class="form-label">Search</label>
                                <input type="text" name="search" id="search" class="form-control" 
                                       placeholder="ID, Vessel, Certificate..." value="<?php echo e(request('search')); ?>">
                            </div>
                            <div class="col-md-2">
                                <label class="form-label">&nbsp;</label>
                                <div class="d-grid">
                                    <button type="submit" class="btn btn-primary">
                                        <i class="fas fa-search"></i> Filter
                                    </button>
                                </div>
                            </div>
                        </div>
                        <div class="row mt-2">
                            <div class="col-md-12">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" name="show_duplicates" value="1" 
                                           id="show_duplicates" <?php echo e(request('show_duplicates') ? 'checked' : ''); ?>>
                                    <label class="form-check-label" for="show_duplicates">
                                        Show only duplicate records
                                    </label>
                                </div>
                            </div>
                        </div>
                        <div class="row mt-2">
                            <div class="col-md-12">
                                <a href="<?php echo e(route('settings.database')); ?>" class="btn btn-outline-secondary btn-sm">
                                    <i class="fas fa-times"></i> Clear Filters
                                </a>
                            </div>
                        </div>
                    </form>
                </div>
            </div>

            <!-- Results -->
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5><i class="fas fa-table"></i> Vessel Certificate Records</h5>
                    <span class="badge bg-info"><?php echo e($vesselCertificates->count()); ?> records</span>
                </div>
                <div class="card-body">
                    <?php if($vesselCertificates->count() > 0): ?>
                        <div class="table-responsive">
                            <table class="table table-striped table-hover">
                                <thead>
                                    <tr>
                                        <th>ID</th>
                                        <th>Vessel</th>
                                        <th>Certificate</th>
                                        <th>ID Number</th>
                                        <th>Department</th>
                                        <th>Issued Date</th>
                                        <th>Expiry Date</th>
                                        <th>Status</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $vesselCertificates; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cert): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e($cert->id); ?></td>
                                            <td><?php echo e($cert->vessel->name); ?></td>
                                            <td>
                                                <span class="badge bg-secondary"><?php echo e($cert->certificate->category); ?></span>
                                                <?php echo e($cert->certificate->name); ?>

                                            </td>
                                            <td><?php echo e($cert->id_no ?: '-'); ?></td>
                                            <td><?php echo e($cert->vessel_department ?: '-'); ?></td>
                                            <td><?php echo e($cert->issued_date ? $cert->issued_date->format('Y-m-d') : '-'); ?></td>
                                            <td><?php echo e($cert->expiry_date ? $cert->expiry_date->format('Y-m-d') : '-'); ?></td>
                                            <td>
                                                <?php if($cert->expiry_date): ?>
                                                    <?php if($cert->expiry_date->isPast()): ?>
                                                        <span class="badge bg-danger">Expired</span>
                                                    <?php elseif($cert->expiry_date->lte(now()->addDays(30))): ?>
                                                        <span class="badge bg-warning text-dark">Expiring Soon</span>
                                                    <?php else: ?>
                                                        <span class="badge bg-success">Valid</span>
                                                    <?php endif; ?>
                                                <?php else: ?>
                                                    <span class="badge bg-secondary">No Expiry</span>
                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <button type="button" class="btn btn-sm btn-danger delete-record-btn"
                                                        data-id="<?php echo e($cert->id); ?>"
                                                        data-vessel="<?php echo e($cert->vessel->name); ?>"
                                                        data-certificate="<?php echo e($cert->certificate->name); ?>">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    <?php else: ?>
                        <div class="text-center py-4">
                            <i class="fas fa-search fa-3x text-muted mb-3"></i>
                            <h5>No records found</h5>
                            <p class="text-muted">Try adjusting your filters to see more results.</p>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Delete Confirmation Modal -->
<div class="modal fade" id="deleteModal" tabindex="-1" aria-labelledby="deleteModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="deleteModalLabel">Confirm Delete</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <p>Are you sure you want to delete this certificate record?</p>
                <div class="alert alert-warning">
                    <strong>Vessel:</strong> <span id="deleteVesselName"></span><br>
                    <strong>Certificate:</strong> <span id="deleteCertificateName"></span>
                </div>
                <p class="text-danger"><strong>This action cannot be undone!</strong></p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                <button type="button" class="btn btn-danger" id="confirmDeleteBtn">
                    <i class="fas fa-trash"></i> Delete Record
                </button>
            </div>
        </div>
    </div>
</div>

<?php $__env->startSection('scripts'); ?>
<script>
// Cache buster: <?php echo e(time()); ?>

// Set base URL for AJAX requests
const baseUrl = '<?php echo e(url('/')); ?>';
console.log('Base URL:', baseUrl);

document.addEventListener('DOMContentLoaded', function() {
    const deleteModal = new bootstrap.Modal(document.getElementById('deleteModal'));
    let currentRecordId = null;

    // Handle delete button clicks
    document.querySelectorAll('.delete-record-btn').forEach(button => {
        button.addEventListener('click', function() {
            currentRecordId = this.getAttribute('data-id');
            const vesselName = this.getAttribute('data-vessel');
            const certificateName = this.getAttribute('data-certificate');

            document.getElementById('deleteVesselName').textContent = vesselName;
            document.getElementById('deleteCertificateName').textContent = certificateName;

            deleteModal.show();
        });
    });

    // Handle confirm delete
    document.getElementById('confirmDeleteBtn').addEventListener('click', function() {
        if (!currentRecordId) return;

        const button = this;
        const originalText = button.innerHTML;

        // Show loading state
        button.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Deleting...';
        button.disabled = true;

        // Send delete request
        const deleteUrl = `${baseUrl}/vessel-certificates/${currentRecordId}`;
        console.log('Deleting certificate with URL:', deleteUrl);

        fetch(deleteUrl, {
            method: 'DELETE',
            headers: {
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
                'Accept': 'application/json',
                'Content-Type': 'application/json'
            }
        })
        .then(response => {
            console.log('Response status:', response.status);
            console.log('Response headers:', response.headers);

            if (!response.ok) {
                throw new Error(`HTTP error! status: ${response.status}`);
            }

            return response.text().then(text => {
                console.log('Raw response:', text);
                try {
                    return JSON.parse(text);
                } catch (e) {
                    console.error('Failed to parse JSON:', e);
                    throw new Error('Invalid JSON response: ' + text.substring(0, 100));
                }
            });
        })
        .then(data => {
            if (data.success) {
                // Close modal
                deleteModal.hide();

                // Show success message
                showAlert('success', data.message);

                // Remove the row from the table
                const row = document.querySelector(`tr:has(button[data-id="${currentRecordId}"])`);
                if (row) {
                    row.remove();
                }

                // Update record count if visible
                const badge = document.querySelector('.badge.bg-info');
                if (badge) {
                    const currentCount = parseInt(badge.textContent.split(' ')[0]);
                    badge.textContent = `${currentCount - 1} records`;
                }
            } else {
                showAlert('danger', data.message || 'Failed to delete record');
            }
        })
        .catch(error => {
            console.error('Error:', error);
            showAlert('danger', 'An error occurred while deleting the record');
        })
        .finally(() => {
            // Reset button state
            button.innerHTML = originalText;
            button.disabled = false;
            currentRecordId = null;
        });
    });

    // Function to show alerts
    function showAlert(type, message) {
        const alertHtml = `
            <div class="alert alert-${type} alert-dismissible fade show" role="alert">
                ${message}
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        `;

        // Insert alert at the top of the container
        const container = document.querySelector('.container-fluid .row .col-12');
        const firstCard = container.querySelector('.card');
        firstCard.insertAdjacentHTML('beforebegin', alertHtml);

        // Auto-dismiss after 5 seconds
        setTimeout(() => {
            const alert = container.querySelector('.alert');
            if (alert) {
                const bsAlert = new bootstrap.Alert(alert);
                bsAlert.close();
            }
        }, 5000);
    }
});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\ASUS\Desktop\vessel-certificates\resources\views/settings/database.blade.php ENDPATH**/ ?>