<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="row mb-3">
        <div class="col-md-12">
            <h2>Dashboard</h2>
        </div>
    </div>

    <div class="row">
        <div class="col-md-4">
            <div class="card">
                <div class="card-header">
                    <h5>Vessels</h5>
                </div>
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <h2><?php echo e(\App\Models\Vessel::count()); ?></h2>
                        <i class="fas fa-ship fa-3x text-primary"></i>
                    </div>
                    <a href="<?php echo e(route('vessels.index')); ?>" class="btn btn-primary mt-3">View All Vessels</a>
                </div>
            </div>
        </div>

        <div class="col-md-4">
            <div class="card">
                <div class="card-header">
                    <h5>Certificates</h5>
                </div>
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <h2><?php echo e(\App\Models\VesselCertificate::count()); ?></h2>
                        <i class="fas fa-certificate fa-3x text-success"></i>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-4">
            <div class="card">
                <div class="card-header">
                    <h5>Users</h5>
                </div>
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <h2><?php echo e(\App\Models\User::count()); ?></h2>
                        <i class="fas fa-users fa-3x text-info"></i>
                    </div>
                    <?php if(auth()->user()->is_admin): ?>
                    <a href="<?php echo e(route('users.index')); ?>" class="btn btn-info mt-3">Manage Users</a>
                    <?php else: ?>
                    <p class="mt-3">Only admins can manage users.</p>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>

    <div class="row mt-4">
        <div class="col-md-6">
            <div class="card">
                <div class="card-header">
                    <h5>Expiring Certificates</h5>
                </div>
                <div class="card-body">
                    <?php
                    $warningSettings = \App\Models\WarningSettings::first();
                    $warningDays = $warningSettings ? $warningSettings->warning_days : 30;
                    $dangerDays = $warningSettings ? $warningSettings->danger_days : 7;

                    $expiringCertificates = \App\Models\VesselCertificate::whereNotNull('expiry_date')
                        ->whereDate('expiry_date', '>=', now())
                        ->whereDate('expiry_date', '<=', now()->addDays($warningDays))
                        ->with(['vessel', 'certificate'])
                        ->orderBy('expiry_date')
                        ->get();
                    ?>

                    <?php if($expiringCertificates->count() > 0): ?>
                    <div class="table-responsive">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th>Vessel</th>
                                    <th>Certificate</th>
                                    <th>Expiry Date</th>
                                    <th>Status</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $expiringCertificates; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cert): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php
                                    $daysLeft = (int)$cert->expiry_date->diffInDays(now());
                                    $isDanger = $cert->expiry_date < now()->addDays($dangerDays);
                                ?>
                                <tr>
                                    <td><?php echo e($cert->vessel->name); ?></td>
                                    <td><?php echo e($cert->certificate->name); ?></td>
                                    <td><?php echo e($cert->expiry_date->format('Y-m-d')); ?></td>
                                    <td>
                                        <?php if($isDanger): ?>
                                            <span class="badge bg-danger">Critical - <?php echo e($daysLeft); ?> days</span>
                                        <?php else: ?>
                                            <span class="badge bg-warning text-dark">Warning - <?php echo e($daysLeft); ?> days</span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <button type="button" class="btn btn-sm btn-primary"
                                                onclick="openCertificateModal(<?php echo e($cert->id); ?>, '<?php echo e($cert->vessel->name); ?>', '<?php echo e($cert->certificate->name); ?>')">
                                            <i class="fas fa-edit"></i> Edit
                                        </button>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                    <?php else: ?>
                    <p>No certificates expiring in the next <?php echo e($warningDays); ?> days.</p>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <div class="col-md-6">
            <div class="card">
                <div class="card-header">
                    <h5>Expired Certificates</h5>
                </div>
                <div class="card-body">
                    <?php
                    $expiredCertificates = \App\Models\VesselCertificate::whereNotNull('expiry_date')
                        ->whereDate('expiry_date', '<', now())
                        ->with(['vessel', 'certificate'])
                        ->orderBy('expiry_date', 'desc')
                        ->get();
                    ?>

                    <?php if($expiredCertificates->count() > 0): ?>
                    <div class="table-responsive">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th>Vessel</th>
                                    <th>Certificate</th>
                                    <th>Expiry Date</th>
                                    <th>Overdue</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $expiredCertificates; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cert): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php
                                    $daysOverdue = (int)now()->diffInDays($cert->expiry_date);
                                ?>
                                <tr>
                                    <td><?php echo e($cert->vessel->name); ?></td>
                                    <td><?php echo e($cert->certificate->name); ?></td>
                                    <td><?php echo e($cert->expiry_date->format('Y-m-d')); ?></td>
                                    <td>
                                        <span class="badge bg-dark text-white">
                                            <?php echo e($daysOverdue); ?> days overdue
                                        </span>
                                    </td>
                                    <td>
                                        <button type="button" class="btn btn-sm btn-primary"
                                                onclick="openCertificateModal(<?php echo e($cert->id); ?>, '<?php echo e($cert->vessel->name); ?>', '<?php echo e($cert->certificate->name); ?>')">
                                            <i class="fas fa-edit"></i> Edit
                                        </button>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                    <?php else: ?>
                    <p>No expired certificates.</p>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Certificate Edit Modal -->
<div class="modal fade" id="editCertificateModal" tabindex="-1" aria-labelledby="editCertificateModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="editCertificateModalLabel">Edit Certificate</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form id="editCertificateForm" method="POST" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label">Vessel</label>
                        <input type="text" class="form-control" id="modalVesselName" readonly>
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Certificate</label>
                        <input type="text" class="form-control" id="modalCertificateName" readonly>
                    </div>

                    <div class="mb-3">
                        <label for="modalIdNo" class="form-label">ID Number</label>
                        <input type="text" class="form-control" id="modalIdNo" name="id_no">
                    </div>

                    <div class="mb-3">
                        <label for="modalDepartment" class="form-label">Department</label>
                        <input type="text" class="form-control" id="modalDepartment" name="vessel_department">
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="modalIssuedDate" class="form-label">Issued Date</label>
                                <input type="date" class="form-control" id="modalIssuedDate" name="issued_date">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="modalExpiryDate" class="form-label">Expiry Date</label>
                                <input type="date" class="form-control" id="modalExpiryDate" name="expiry_date">
                            </div>
                        </div>
                    </div>

                    <div class="mb-3">
                        <label for="modalAttachment" class="form-label">Certificate Files</label>
                        <input type="file" class="form-control" id="modalAttachment" name="attachments[]" accept=".pdf,.jpg,.jpeg,.png" multiple>
                        <div class="form-text">Upload new files (multiple files supported). New files will replace existing ones.</div>

                        <!-- Current Attachments -->
                        <div id="currentAttachments" class="mt-3">
                            <h6>Current Attachments:</h6>
                            <div id="attachmentsList"></div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary">Update Certificate</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
function openCertificateModal(certificateId, vesselName, certificateName) {
    // Set basic info
    document.getElementById('modalVesselName').value = vesselName;
    document.getElementById('modalCertificateName').value = certificateName;

    // Set form action
    document.getElementById('editCertificateForm').action = `/vessel-certificates/${certificateId}`;

    // Fetch certificate data
    fetch(`/vessel-certificates/${certificateId}/edit`)
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                const cert = data.certificate;

                // Populate form fields
                document.getElementById('modalIdNo').value = cert.id_no || '';
                document.getElementById('modalDepartment').value = cert.vessel_department || '';
                document.getElementById('modalIssuedDate').value = cert.issued_date || '';
                document.getElementById('modalExpiryDate').value = cert.expiry_date || '';

                // Show current attachments
                displayCurrentAttachments(cert.attachment_path, cert.id);

                // Show modal
                new bootstrap.Modal(document.getElementById('editCertificateModal')).show();
            } else {
                alert('Error loading certificate data: ' + data.message);
            }
        })
        .catch(error => {
            console.error('Error:', error);
            alert('Error loading certificate data');
        });
}

// Handle form submission
document.getElementById('editCertificateForm').addEventListener('submit', function(e) {
    e.preventDefault();

    const formData = new FormData(this);
    const actionUrl = this.action;

    // Debug: Log form data
    console.log('Form action URL:', actionUrl);
    console.log('Form data entries:');
    for (let [key, value] of formData.entries()) {
        console.log(key, value);
    }

    fetch(actionUrl, {
        method: 'POST',
        body: formData,
        headers: {
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
            'X-Requested-With': 'XMLHttpRequest'
        }
    })
    .then(response => {
        console.log('Response status:', response.status);
        console.log('Response headers:', response.headers.get('content-type'));

        if (!response.ok) {
            throw new Error(`HTTP error! status: ${response.status}`);
        }

        return response.text().then(text => {
            console.log('Raw response:', text);
            try {
                return JSON.parse(text);
            } catch (e) {
                console.error('Failed to parse JSON:', e);
                console.error('Response text:', text.substring(0, 500));
                throw new Error('Server returned invalid JSON response. Check console for details.');
            }
        });
    })
    .then(data => {
        if (data.success) {
            // Close modal
            bootstrap.Modal.getInstance(document.getElementById('editCertificateModal')).hide();

            // Show success message and reload page
            alert('Certificate updated successfully!');
            location.reload();
        } else {
            alert('Error updating certificate: ' + data.message);
        }
    })
    .catch(error => {
        console.error('Error:', error);
        alert('Error updating certificate: ' + error.message);
    });
});

// Function to display current attachments with individual delete buttons
function displayCurrentAttachments(attachmentPath, certificateId) {
    const attachmentsListDiv = document.getElementById('attachmentsList');

    if (!attachmentPath) {
        attachmentsListDiv.innerHTML = '<div class="text-muted">No files currently uploaded</div>';
        return;
    }

    let attachments = [];

    // Handle different attachment path formats
    if (typeof attachmentPath === 'string') {
        try {
            // Try to parse as JSON array
            const parsed = JSON.parse(attachmentPath);
            if (Array.isArray(parsed)) {
                attachments = parsed;
            } else {
                // Single attachment as string
                attachments = [attachmentPath];
            }
        } catch (e) {
            // Single attachment as string
            attachments = [attachmentPath];
        }
    } else if (Array.isArray(attachmentPath)) {
        attachments = attachmentPath;
    }

    if (attachments.length === 0) {
        attachmentsListDiv.innerHTML = '<div class="text-muted">No files currently uploaded</div>';
        return;
    }

    let html = '';
    attachments.forEach((attachment, index) => {
        const fileName = attachment.split('/').pop();
        html += `
            <div class="mb-2 d-flex align-items-center justify-content-between attachment-item" data-index="${index}">
                <span class="text-muted small">${fileName}</span>
                <div class="btn-group">
                    <a href="/storage/${attachment}" target="_blank" class="btn btn-sm btn-info">
                        <i class="fas fa-eye"></i> View
                    </a>
                    <a href="/storage/${attachment}" download class="btn btn-sm btn-primary">
                        <i class="fas fa-download"></i> Download
                    </a>
                    <button type="button" class="btn btn-sm btn-danger delete-attachment-btn"
                            data-cert-id="${certificateId}"
                            data-index="${index}"
                            data-attachment="${attachment}">
                        <i class="fas fa-trash"></i> Delete
                    </button>
                </div>
            </div>
        `;
    });

    attachmentsListDiv.innerHTML = html;

    // Add event listeners to delete buttons
    attachmentsListDiv.querySelectorAll('.delete-attachment-btn').forEach(btn => {
        btn.addEventListener('click', function() {
            deleteAttachment(this);
        });
    });
}

// Function to delete individual attachment
function deleteAttachment(button) {
    if (!confirm('Are you sure you want to delete this attachment?')) {
        return;
    }

    const certId = button.getAttribute('data-cert-id');
    const attachmentIndex = button.getAttribute('data-index');
    const attachmentPath = button.getAttribute('data-attachment');

    // Show loading state
    const originalText = button.innerHTML;
    button.innerHTML = '<i class="fas fa-spinner fa-spin"></i>';
    button.disabled = true;

    // Send delete request
    fetch('<?php echo e(route("vessel-certificates.remove-attachment")); ?>', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
            'X-Requested-With': 'XMLHttpRequest'
        },
        body: JSON.stringify({
            vessel_certificate_id: certId,
            attachment_index: parseInt(attachmentIndex),
            attachment_path: attachmentPath
        })
    })
    .then(response => {
        if (!response.ok) {
            throw new Error(`HTTP error! status: ${response.status}`);
        }
        return response.json();
    })
    .then(data => {
        if (data.success) {
            // Remove the attachment item from the display
            const attachmentItem = button.closest('.attachment-item');
            attachmentItem.remove();

            // Check if no attachments left
            const attachmentsList = document.getElementById('attachmentsList');
            if (attachmentsList.children.length === 0) {
                attachmentsList.innerHTML = '<div class="text-muted">No files currently uploaded</div>';
            }

            // Show success message
            showModalAlert('success', 'Attachment deleted successfully!');
        } else {
            throw new Error(data.message || 'Failed to delete attachment');
        }
    })
    .catch(error => {
        console.error('Error:', error);
        showModalAlert('danger', 'Error deleting attachment: ' + error.message);

        // Reset button state
        button.innerHTML = originalText;
        button.disabled = false;
    });
}

// Function to show alerts inside the modal
function showModalAlert(type, message) {
    const modalBody = document.querySelector('#editCertificateModal .modal-body');

    // Remove existing alerts
    const existingAlerts = modalBody.querySelectorAll('.alert');
    existingAlerts.forEach(alert => alert.remove());

    // Create new alert
    const alertDiv = document.createElement('div');
    alertDiv.className = `alert alert-${type} alert-dismissible fade show`;
    alertDiv.innerHTML = `
        ${message}
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    `;

    // Insert at the top of modal body
    modalBody.insertBefore(alertDiv, modalBody.firstChild);

    // Auto-dismiss after 3 seconds
    setTimeout(() => {
        if (alertDiv.parentNode) {
            alertDiv.remove();
        }
    }, 3000);
}
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\ASUS\Desktop\vessel-certificates\resources\views/dashboard.blade.php ENDPATH**/ ?>